#include "../include/typedefs.h"

// Example code from MISRA C:2012 begin
extern volatile uint16_t v;

extern char *p;

void f ( void )
{
  uint16_t x;

  ( void ) v;     /* Compliant     - v is accessed for its side effect
                   *                 and the cast to void is permitted
                   *                 by exception                      */
  ( int32_t ) v;  /* Non-compliant - the cast operator is dead         */
  v >> 3;         /* Non-compliant - the >> operator is dead           */
  x = 3;          /* Non-compliant - the = operator is dead
                   *               - x is not subsequently read        */
  *p++;           /* Non-compliant - result of * operator is not used  */
  ( *p )++;       /* Compliant     - *p is incremented	               */
}

/* Compliant */
__asm ( "NOP" );

void g ( void )
{
  /* Compliant - there are no operations in this function */
}

void h ( void )
{
  g ( );  /* Non-compliant - the call could be removed    */
}
// Example code from MISRA C:2012 end
